<?php

/**
 * Plugin Name: Junar DataStream Widget
 * Plugin URI: http://www.junar.com/widgets
 * Description: A widget that display Junar Data Streams
 * Version: 1.0
 * Author: Joaquin Nunez and Emilio Heck
 * Author URI: http://joaquinnunez.cl/
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/**
 * JunarDataStreamWidget Class
 */
class JunarDataStreamWidget extends WP_Widget {
	
	/** constructor */
    function JunarDataStreamWidget() {
		parent::WP_Widget(false, $name = 'Junar DataStream');
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract( $args );
        $guid  = apply_filters('widget_guid', $instance['guid']);
		$width = esc_attr($instance['width']);
		$height = esc_attr($instance['height']);
		$param1 = esc_attr($instance['param1']);
		$param2 = esc_attr($instance['param2']);
		$param3 = esc_attr($instance['param3']);
		$param4 = esc_attr($instance['param4']);
		$param5 = esc_attr($instance['param5']);
		
		if( $guid == "" )
			$guid = "WORLD-DIGIT-ACCES-INDEX-2010";
		if( $width == "" )
			$width = "200";
		if( $height == "" )
			$height = "300";
			
		$argument = "%26pArgument0=" . $param1 . "%26pArgument1%3D" . $param2 . "%26pArgument2%3D" . $param3 . "%26pArgument3%3D" . $param4 . "%26pArgument4%3D" . $param5;

        ?>
			<?php echo $before_widget; ?>		
			<iframe
				title="Junar DataStream"
				width="<?php echo $width; ?>"
				height="<?php echo $height; ?>"
				src="<?php echo "http://www.junar.com/portal/DataServicesManager/actionEmbed?guid=" . $guid . "&amp;end_point=" . $argument?>"
				frameborder="0">
			</iframe>
			<p style="text-align:right;padding-top:3px;font-size:11px;color:#999;">
				Powered by <a href="http://www.junar.com" title="Junar &middot; Discovering Data" style="color:#0862A2;">Junar</a>
			</p>
		<?php echo $after_widget; ?>
		<?php
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['guid'] = strip_tags($new_instance['guid']);
		$instance['width'] = strip_tags($new_instance['width']);
		$instance['height'] = strip_tags($new_instance['height']);
		$instance['param1'] = strip_tags($new_instance['param1']);
		$instance['param2'] = strip_tags($new_instance['param2']);
		$instance['param3'] = strip_tags($new_instance['param3']);
		$instance['param4'] = strip_tags($new_instance['param4']);
		$instance['param5'] = strip_tags($new_instance['param5']);
		
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $guid = esc_attr($instance['guid']);
		$width = esc_attr($instance['width']);
		$height = esc_attr($instance['height']);
		$param1 = esc_attr($instance['param1']);
		$param2 = esc_attr($instance['param2']);
		$param3 = esc_attr($instance['param3']);
		$param4 = esc_attr($instance['param4']);
		$param5 = esc_attr($instance['param5']);
        ?>
			<p>
				<label for="<?php echo $this->get_field_id('guid'); ?>"><?php _e('GUID:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('guid'); ?>" name="<?php echo $this->get_field_name('guid'); ?>" type="text" value="<?php echo $guid; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Width:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('width'); ?>" name="<?php echo $this->get_field_name('width'); ?>" type="text" value="<?php echo $width; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('height'); ?>"><?php _e('Height:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('height'); ?>" name="<?php echo $this->get_field_name('height'); ?>" type="text" value="<?php echo $height; ?>" />
			</p>
			<p><label>Optional parameters:</label></p>
			<p>
				<label for="<?php echo $this->get_field_id('param1'); ?>"><?php _e('Parameter 1:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('param1'); ?>" name="<?php echo $this->get_field_name('param1'); ?>" type="text" value="<?php echo $param1; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('param2'); ?>"><?php _e('Parameter 2:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('param2'); ?>" name="<?php echo $this->get_field_name('param2'); ?>" type="text" value="<?php echo $param2; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('param3'); ?>"><?php _e('Parameter 3:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('param3'); ?>" name="<?php echo $this->get_field_name('param3'); ?>" type="text" value="<?php echo $param3; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('param4'); ?>"><?php _e('Parameter 4:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('param4'); ?>" name="<?php echo $this->get_field_name('param4'); ?>" type="text" value="<?php echo $param4; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('param5'); ?>"><?php _e('Parameter 5:'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('param5'); ?>" name="<?php echo $this->get_field_name('param5'); ?>" type="text" value="<?php echo $param5; ?>" />
			</p>
        <?php
    }
} // class FooWidget

add_action('widgets_init', 'loadJunarWidget');

function loadJunarWidget() { 
    return register_widget("JunarDataStreamWidget");
}
?>